/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class AdminToolItem
extends Item {
    public AdminToolItem() {
        if (ConfigHandler.allowAdminTool) {
            this.func_77637_a(SecurityCraft.TECHNICAL_TAB);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K && ConfigHandler.allowAdminTool) {
            if (!player.func_184812_l_()) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), TextFormatting.DARK_PURPLE);
                return EnumActionResult.SUCCESS;
            }
            EnumActionResult briefcaseResult = this.handleBriefcase(player, hand).func_188397_a();
            if (briefcaseResult != EnumActionResult.PASS) {
                return briefcaseResult;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                List<ModuleType> modules;
                if (te instanceof DisplayCaseBlockEntity && ((DisplayCaseBlockEntity)te).isOpen() && ((DisplayCaseBlockEntity)te).getDisplayedStack().func_190926_b()) {
                    return EnumActionResult.PASS;
                }
                boolean hasInfo = false;
                if (te instanceof IOwnable) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.owner.name", ((IOwnable)te).getOwner().getName() == null ? "????" : ((IOwnable)te).getOwner().getName()), TextFormatting.DARK_PURPLE);
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.owner.uuid", ((IOwnable)te).getOwner().getUUID() == null ? "????" : ((IOwnable)te).getOwner().getUUID()), TextFormatting.DARK_PURPLE);
                    hasInfo = true;
                }
                if (te instanceof IModuleInventory && !(modules = ((IModuleInventory)te).getInsertedModules()).isEmpty()) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.equippedModules", new Object[0]), TextFormatting.DARK_PURPLE);
                    for (ModuleType module : modules) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), new TextComponentString("- ").func_150257_a((ITextComponent)Utils.localize(module.getTranslationKey(), new Object[0])), TextFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (te instanceof SecretSignBlockEntity) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)new TextComponentString(""), TextFormatting.DARK_PURPLE);
                    for (int i = 0; i < 4; ++i) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), ((SecretSignBlockEntity)te).field_145915_a[i], TextFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (!hasInfo) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), TextFormatting.DARK_PURPLE);
                }
                return EnumActionResult.SUCCESS;
            }
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), TextFormatting.DARK_PURPLE);
        } else {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:adminTool.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.disabled", new Object[0]), TextFormatting.DARK_PURPLE);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_184812_l_()) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_77658_a(), new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), TextFormatting.DARK_PURPLE);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        return this.handleBriefcase(player, hand);
    }

    private ActionResult<ItemStack> handleBriefcase(EntityPlayer player, EnumHand hand) {
        ItemStack adminTool = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.briefcase) {
            ItemStack briefcase = player.func_184592_cb();
            TextComponentTranslation adminToolName = Utils.localize(this.func_77658_a(), new Object[0]);
            String ownerName = BriefcaseItem.getOwnerName(briefcase);
            String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)adminToolName, (ITextComponent)Utils.localize("messages.securitycraft:adminTool.owner.name", ownerName.isEmpty() ? "????" : ownerName), TextFormatting.DARK_PURPLE);
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)adminToolName, (ITextComponent)Utils.localize("messages.securitycraft:adminTool.owner.uuid", ownerUUID.isEmpty() ? "????" : ownerUUID), TextFormatting.DARK_PURPLE);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)adminTool);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)adminTool);
    }
}

